(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4191,        169]*)
(*NotebookOutlinePosition[      5047,        199]*)
(*  CellTagsIndexPosition[      5003,        195]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Horner's Method for Polynomial Evaluation", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->27],

Cell["\<\
Off[General::spell1];
Clear[Horner,P0,t,x];
Horner[P0_,t_] := 
Module[{c,P,k,n,X},
  Set@@{P[x_],P0};
  X = Variables[P[x]][[1]];
  c = CoefficientList[P[x],X];
  n = Length[c]-1;
  poly = c[[n+1]];
  For[k=n-1,0<=k,k--,
    poly = c[[k+1]] + poly t ];
  Return[poly]; ];\
\>", "Input",
  AspectRatioFixed->False,
  FontSize->17],

Cell[TextData[{
  StyleBox["Example 1.",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[
  " Find  Horner's nested form of the polynomial for \nthe polynomial\n       \
   ",
    FontSlant->"Plain"],
  StyleBox["    ",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox["3x^3 - 2x^2 + 5x - 7",
    FontFamily->"Courier",
    FontSlant->"Plain"]
}], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->19],

Cell["\<\
Clear[P,x];
P[x_] = 3x^3 - 2x^2 + 5x - 7  \
\>", "Input",
  AspectRatioFixed->False,
  FontSize->17],

Cell["\<\
Clear[Q,x]; 
Q[x_] = Horner[P[x],x]\
\>", "Input",
  AspectRatioFixed->False,
  FontSize->17],

Cell[TextData[{
  StyleBox["Example 2.",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[
  " Find  Horner's nested form of the polynomial for \nthe polynomial\n  ",
    FontSlant->"Plain"],
  StyleBox[" x^5 - 6 x^4 + 8 x^3 + 8 x^2 + 4 x - 40",
    FontFamily->"Courier",
    FontSlant->"Plain"]
}], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->19],

Cell["\<\
Clear[P,Q]
P[x_] = x^5 - 6 x^4 + 8 x^3 + 8 x^2 + 4 x - 40; 
Q[x_] = Horner[P[x],x];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->17],

Cell["Print[Q[x]] ", "Input",
  AspectRatioFixed->True,
  FontSize->17],

Cell[TextData[StyleBox[
"Consider the computational time for evaluating P(x) and the \nnested form \
Q(x)",
  FontSlant->"Plain"]], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->19],

Cell["\<\
V = Table[i,{i,1,200}];
Ptimeset = Timing[P[V]];
Qtimeset = Timing[Q[V]]; 
Ptimeset[[1]]
Qtimeset[[1]]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->17],

Cell["\<\
V = Table[i,{i,1,400}]; 
Ptimeset = Timing[P[V]];
Qtimeset = Timing[Q[V]];
Ptimeset[[1]]
Qtimeset[[1]]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->17],

Cell["\<\
V = Table[i,{i,1,800}]; 
Ptimeset = Timing[P[V]];
Qtimeset = Timing[Q[V]];
Ptimeset[[1]]
Qtimeset[[1]]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->17]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 600},
WindowMargins->{{Automatic, 117}, {80, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 128, 3, 37, "Left Header"],
Cell[1840, 54, 339, 15, 228, "Input"],
Cell[2182, 71, 447, 17, 71, "Header"],
Cell[2632, 90, 110, 5, 48, "Input"],
Cell[2745, 97, 103, 5, 48, "Input"],
Cell[2851, 104, 385, 13, 71, "Header"],
Cell[3239, 119, 150, 6, 84, "Input"],
Cell[3392, 127, 71, 2, 30, "Input"],
Cell[3466, 131, 205, 6, 49, "Header"],
Cell[3674, 139, 169, 8, 102, "Input"],
Cell[3846, 149, 169, 8, 102, "Input"],
Cell[4018, 159, 169, 8, 102, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

