(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3148,        119]*)
(*NotebookOutlinePosition[      4004,        149]*)
(*  CellTagsIndexPosition[      3960,        145]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[StyleBox["Pertubation of Roots",
  FontFamily->"Times",
  FontSize->36,
  FontWeight->"Roman",
  FontSlant->"Italic"]], "Input",
  AspectRatioFixed->True,
  FontSize->24],

Cell["\<\
Finding roots of polynomials  is very sensitive numerically. 
Here is an example.  \
\>", "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20,
  FontSlant->"Plain"],

Cell["\<\
f[x_] = x^8 - 36 x^7 + 546 x^6 - 
4536 x^5 + 22449 x^4 - 67284 x^3 + 118124 x^2 - 109584 x + 40320\
\>", "Input",\

  AspectRatioFixed->True,
  FontSize->18],

Cell["Factor[%] ", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["Plot[f[x],{x,0,10}]", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
We now replace  the coefficient  -36  in  f (x)  to  -36.001,
and call the new polynomial  g(x).  \
\>", "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20,
  FontSlant->"Plain"],

Cell["\<\
g[x_] = x^8 - 36.001 x^7 + 546 x^6 - 
4536 x^5 + 22449 x^4 - 67284 x^3 + 
118124 x^2 - 109584 x + 40320\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["Factor[%]", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Plot[g[x],{x,0,10}] 
\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
You can see that the roots of  g(x) is quite different from
 f(x). \
\>", "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20,
  FontSlant->"Plain"]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 600},
WindowMargins->{{Automatic, 127}, {Automatic, -4}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 184, 6, 49, "Input"],
Cell[1896, 57, 195, 7, 51, "Header"],
Cell[2094, 66, 167, 6, 63, "Input"],
Cell[2264, 74, 69, 2, 29, "Input"],
Cell[2336, 78, 78, 2, 29, "Input"],
Cell[2417, 82, 210, 7, 51, "Header"],
Cell[2630, 91, 170, 6, 63, "Input"],
Cell[2803, 99, 68, 2, 29, "Input"],
Cell[2874, 103, 88, 5, 46, "Input"],
Cell[2965, 110, 179, 7, 51, "Header"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

