(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9505,        375]*)
(*NotebookOutlinePosition[     10360,        405]*)
(*  CellTagsIndexPosition[     10316,        401]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Least Square Problem with Normal Eqn: ", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->28],

Cell[TextData[{
  StyleBox[" ",
    FontSize->16,
    FontSlant->"Plain"],
  StyleBox[
  "We consider the least square problem: Find the solution\nof AX=b in the \
least square sense;  the normal equation is \n             A*A x = A*b. \nIf \
we  consider the least square fit of the data  \n{(Xi, Yi), i =1, ..., N} by \
a polynomial of degree n:\n             P(x) = a0 + a1 x + a2 x^2 + ... +  an \
x^n,\nthen AX= b is given by P(Xi)  = Yi,  i=1,...,N,  so that \nA = ( a_ij)  \
where a_ij = Xi^j , X=(a0,a1,a2, ... ,an)^T, \nand b = (Y1, Y2, ..., YN)^T.",
    FontSize->20]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->24],

Cell[TextData[StyleBox["Let us consider the following example:",
  FontSize->19,
  FontSlant->"Plain"]], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->26],

Cell["\<\
Clear[XY, n]; 
f[x_]:=1 + Sin[10 x]; 
pt[x_]:= 10+ (x-1)/14; 
n=15;
XY=N[Table[{pt[i], f[pt[i]]},  {i, 1,n}],10];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox["A and b are given by:",
  FontSlant->"Plain"]], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell["\<\
A = Table[{1, XY[[i,1]], XY[[i,1]]^2,
  XY[[i,1]]^3, XY[[i,1]]^4,
  XY[[i,1]]^5,XY[[i,1]]^6},{i, 1,n}];
b = Table[ XY[[i,2]], {i,1,n}];
MatrixForm[A];  \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox["The corresponding normal equation is  :",
  FontSlant->"Plain"]], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell["\<\
ATA = Transpose[A].A ;
ATb = Transpose[A].b ; 
 MatrixForm[ATA]; 
 MatrixForm[ATb]; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox["Mehtod 1:",
    FontSize->19,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[" Let us solve the normal equation by Gauss \nelimination",
    FontSize->19,
    FontSlant->"Plain"],
  StyleBox[", ",
    FontSize->23,
    FontSlant->"Plain"],
  StyleBox["we need to open the notebook \"gauss.ma\" first:",
    FontSlant->"Plain"]
}], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell["\<\
Clear[LU];
LU=GaussLU[ATA];
a1=N[GaussSol[LU,ATb], digit]  \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox[
"Here is the least square polynomial from this solution:",
  FontSize->19,
  FontSlant->"Plain"]], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell["\<\
least1[x_] =a1[[1]] + a1[[2]]x + 
  a1[[3]]x^2+a1[[4]]x^3+a1[[5]]x^4+ 
  a1[[6]] x^5 + a1[[7]] x^6 \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox["Here is the graph of the data and the polynomial:  ",
  FontSize->19,
  FontSlant->"Plain"]], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell["\<\
Clear[nodes,gp1]
nodes=ListPlot[XY,PlotStyle->
  PointSize[.02],
DisplayFunction->Identity]; 
gp1=Plot[least1[x],{x,10,11},
   DisplayFunction->Identity];
Show[nodes, gp1,DisplayFunction->
   $DisplayFunction]          \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox["Mehtod 2:",
    FontSize->19,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[" ",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[
  "Let us solve the normal equation by using the\nGram-Schmidt factorization \
A=GS. T first, and then solve \nT X = B with  B=GS* b  using the \
back-substitution. We\nuse the notebooks \"gram-sh.ma\"  and \"backsub.ma\". \
",
    FontSlant->"Plain"]
}], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell[TextData[StyleBox[
"Here we run the Gram-Schmidt, compute B, and solve \nt X =B by substitution: \
 ",
  FontSize->19,
  FontSlant->"Plain"]], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell["\<\
Clear[GS,B]
GS=GramSchmidt[A];
B= Transpose[GS] . b; 
a2 = BackSub[t,B] \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox[
"Here is the least square polynomial from this solution:",
  FontSize->19,
  FontSlant->"Plain"]], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell["\<\
least2[x_] = a2[[1]] + a2[[2]]x + 
  a2[[3]]x^2 + a2[[4]]x^3 +a2[[5]]x^4+
  a2[[6]]x^5 + a2[[7]]x^6\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox["Here is the graph of the data and the polynomial:  ",
  FontSize->19,
  FontSlant->"Plain"]], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell["\<\
Clear[gp2]
gp2=Plot[least2[x],{x, 10, 11},DisplayFunction->Identity];
Show[nodes, gp2,DisplayFunction->
  $DisplayFunction]          \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox["Comparision: ",
    FontSize->19,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[
  "Evidently, the second one is much better.  We \ncan also see this by \
computing the lest squre error: ",
    FontSize->19,
    FontSlant->"Plain"]
}], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell["\<\
error1=Sum[(least1[pt[i]]-f[pt[i]])^2, 
  {i, 1,15}]//N  \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
error2=Sum[(least2[pt[i]]-f[pt[i]])^2, 
  {i, 1,15}]//N  \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox[
"In fact, both a1 and a2 are solutions of normal equation. But \ntheir \
difference is as much as 10^8 !! Let us print them down \nagain.",
  FontSize->19,
  FontSlant->"Plain"]], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell["a1", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["a2", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox[
"Here is their difference, where the norm is the || .||_2 norm \ndefined in \
the \"gram-sh.ma\": ",
  FontSize->19,
  FontSlant->"Plain"]], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell["norm[a1-a2]", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox[
"The reason for this difference is that ATA is  ill-conditioned. \nHence, the \
system is unstabled. The solution by Gaussian \nelimination will have a large \
error. Here is the condition \nnumber ",
  FontSize->19,
  FontSlant->"Plain"]], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell["\<\
eigens = Eigenvalues[ATA];
Cond[ATA] = Max[Abs[eigens]] /
    Min[Abs[eigens]]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox["Compare with the ",
    FontSize->19,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox["Mathematica",
    FontSize->19,
    FontWeight->"Bold"],
  StyleBox[" build-in command \"Fit\": ",
    FontSize->19,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[" \nThe ",
    FontSize->19,
    FontSlant->"Plain"],
  StyleBox["mathematica",
    FontSize->19],
  StyleBox[" solution of the Example 2 is bad !! ",
    FontSize->19,
    FontSlant->"Plain"]
}], "Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->20],

Cell["\<\
Clear[f];
f[x_]=Fit[XY, {1,x,x^2, x^3, x^4,
    x^5, x^6}, x]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[dots, least];
dots = ListPlot[XY,PlotStyle->{PointSize[0.02]},DisplayFunction->
    Identity];
least= Plot[f[x],{x,10,11}, 
    DisplayFunction->Identity];
Show[least, dots, DisplayFunction->
 $DisplayFunction,
PlotLabel->txt,AxesLabel->{\"x\",\"y  \"}]
\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 600},
WindowMargins->{{Automatic, 173}, {Automatic, 9}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 125, 3, 39, "Left Header"],
Cell[1837, 54, 660, 15, 215, "Left Header"],
Cell[2500, 71, 178, 5, 27, "Header"],
Cell[2681, 78, 180, 8, 114, "Input"],
Cell[2864, 88, 145, 4, 28, "Header"],
Cell[3012, 94, 219, 8, 97, "Input"],
Cell[3234, 104, 163, 4, 28, "Header"],
Cell[3400, 110, 151, 7, 80, "Input"],
Cell[3554, 119, 445, 16, 52, "Header"],
Cell[4002, 137, 126, 6, 63, "Input"],
Cell[4131, 145, 196, 6, 27, "Header"],
Cell[4330, 153, 166, 6, 63, "Input"],
Cell[4499, 161, 191, 5, 27, "Header"],
Cell[4693, 168, 286, 11, 148, "Input"],
Cell[4982, 181, 531, 18, 97, "Header"],
Cell[5516, 201, 221, 7, 49, "Header"],
Cell[5740, 210, 139, 7, 80, "Input"],
Cell[5882, 219, 196, 6, 27, "Header"],
Cell[6081, 227, 166, 6, 63, "Input"],
Cell[6250, 235, 191, 5, 27, "Header"],
Cell[6444, 242, 200, 7, 97, "Input"],
Cell[6647, 251, 351, 13, 49, "Header"],
Cell[7001, 266, 124, 5, 46, "Input"],
Cell[7128, 273, 124, 5, 46, "Input"],
Cell[7255, 280, 277, 7, 71, "Header"],
Cell[7535, 289, 61, 2, 29, "Input"],
Cell[7599, 293, 61, 2, 29, "Input"],
Cell[7663, 297, 238, 7, 49, "Header"],
Cell[7904, 306, 70, 2, 29, "Input"],
Cell[7977, 310, 338, 8, 93, "Header"],
Cell[8318, 320, 145, 6, 63, "Input"],
Cell[8466, 328, 574, 23, 50, "Header"],
Cell[9043, 353, 128, 6, 63, "Input"],
Cell[9174, 361, 327, 12, 182, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

