(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6967,        285]*)
(*NotebookOutlinePosition[      7823,        315]*)
(*  CellTagsIndexPosition[      7779,        311]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["LU Decomposition: ", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->28],

Cell["\<\
The following is the LU decomposition of a matrix A,
where L is  a lower triangular matrix and U is an unit 
upper triangular matrix.The outcome of L and U is
put into one matrix since the diagonal elements of
Uare equal to 1. We  use \"digit\" in the algorithm so 
that every step is computed up to the given digits.\
\>", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->22],

Cell["\<\
Off[General::spell1];
Clear[LUdeco,a0];
LUdeco[a0_] :=
Module[{a, i,j,k,p,q,m, n},
  a = a0; 
  n= Length[a];
    Module[{i,j},  
   x = Table[0,{i,n},{j,n}];
    Clear[i,j,k,m,p,q]; 
    For[k=1, k <=n, k++,
      x[[k,k]]= N[a[[k,k]]-
          Sum[x[[k,m]] x[[m,k]], 
            {m,1,k-1}],digit]  ;  
      For[j=k+1,j<=n,j++,
       x[[k,j]]= N[(a[[k,j]]- 
         Sum[x[[k,p]] x[[p,j]], 
         {p,1,k-1}])/ x[[k,k]],digit] ]; 
      For[i=k+1,i<=n,i++,
       x[[i,k]]= N[a[[i,k]]- 
          Sum[x[[i,q]] x[[q,k]], 
            {q,1,k-1}],digit]  ]; 
    ]; ]; 
    Clear[L,U,LU];
     L=Table[If[i >=j, x[[i,j]], 0],  \t\t\t\t{i,n},{j,n}];
     U=Table[If[i !=j,  If[i < j, 
     \tx[[i,j]], 0],  1],{i,n},{j,n}];  
   Return[x]; ];  
 On[General::spell1]; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox[
"The following line defines \"digit =10\", so that each\nstep is computed up \
to 10 decimal points.",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[digit]; 
digit = 10;\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox["Examle 1",
    FontSize->22,
    FontWeight->"Bold"],
  StyleBox[": Here is a matrix of 3 by 3 in the book:",
    FontSize->22]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[A];
A={{60,30,20}, {30,20,15}, {20,15,12}};
MatrixForm[A] \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[LU, L, U];
LU = LUdeco[A];  
MatrixForm[LU]   \
\>", "Input",
  AspectRatioFixed->False,
  FontSize->18],

Cell[TextData[StyleBox["Let us seperate L and U:   ",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
MatrixForm[L]//N
MatrixForm[U]//N   \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox["Let us verify the factorization:  ",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["MatrixForm[L.U ]   ", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox["Examle 2",
    FontSize->22,
    FontWeight->"Bold"],
  StyleBox[": Here is a matrix of 4 by 4:",
    FontSize->22]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[A];
A = {{2,4,-4,0},{1,5,-5,-3},{2,3,1,3},{1,4,-2,2}}; 
MarixForm[A]  \
\>", "Input",
  AspectRatioFixed->False,
  FontSize->18],

Cell["\<\
Clear[LU,L,U];
LU = LUdeco[A]; 
MatrixForm[LU]//N  \
\>", "Input",
  AspectRatioFixed->False,
  FontSize->18],

Cell[TextData[{
  StyleBox["Let us seperate L and U: ",
    FontSize->22],
  StyleBox[" ",
    FontSize->16,
    FontSlant->"Plain"]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
MatrixForm[L]//N
MatrixForm[U]//N\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox["Let us verify the factorization:  ",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["MatrixForm[L.U ]  ", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["Solving Equations with LU Decomposition:  ", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->28],

Cell[TextData[StyleBox[
"After LU decomposition, the system of equations \ncan be solved easily: we \
use forward substitution to \nsolve LY=B for Y and then backward substitution \
\nto solve UX=Y for X.",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Off[General::spell1];
Clear[SolveLU,a0,b0];
SolveLU[a0_,b0_] :=
Module[{a,b,x,k,sum, n},
  a = a0;
  b = b0;
  n= Length[b];
    x = Table[0,{i,n}];
    Clear[i,j]; 
    For[i=1, i <=n, i++,
      x[[i]] = N[(b[[i]] - 
          Sum[a[[i,j]] x[[j]],
       {j, 1, i-1}])/a[[i,i]],digit]; ];
    Clear[i,j];
    For[i=n,1<=i,i--,
      x[[i]]= N[x[[i]]-Sum[a[[i,j]]*
        x[[j]],{j,i+1,n}],digit]; ]; 
  Return[x]; ];
On[General::spell1];\
\>", "Input",
  AspectRatioFixed->False,
  FontSize->18],

Cell[TextData[{
  StyleBox["Examle 2'",
    FontSize->20,
    FontWeight->"Bold"],
  StyleBox[
  ": Here is a system of equations of 4 variables, \nthe matrix is the same \
one appeared in the above:",
    FontSize->20]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
A = {{2,4,-4,0},{1,5,-5,-3},{2,3,1,3},{1,4,-2,2}};
B = {12,18,8,8}; 
MatrixForm[A] \
\>", "Input",
  AspectRatioFixed->False,
  FontSize->18],

Cell["\<\
LU = LUdeco[A];
X = SolveLU[LU,B]   \
\>", "Input",
  AspectRatioFixed->False,
  FontSize->18]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 600},
WindowMargins->{{Automatic, 184}, {43, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 105, 3, 39, "Left Header"],
Cell[1817, 54, 412, 10, 152, "Left Header"],
Cell[2232, 66, 837, 31, 505, "Input"],
Cell[3072, 99, 223, 6, 56, "Left Header"],
Cell[3298, 107, 93, 5, 46, "Input"],
Cell[3394, 114, 238, 9, 32, "Left Header"],
Cell[3635, 125, 131, 6, 63, "Input"],
Cell[3769, 133, 120, 6, 63, "Input"],
Cell[3892, 141, 150, 4, 32, "Left Header"],
Cell[4045, 147, 103, 5, 46, "Input"],
Cell[4151, 154, 157, 4, 32, "Left Header"],
Cell[4311, 160, 78, 2, 29, "Input"],
Cell[4392, 164, 226, 9, 32, "Left Header"],
Cell[4621, 175, 144, 6, 80, "Input"],
Cell[4768, 183, 119, 6, 63, "Input"],
Cell[4890, 191, 215, 9, 32, "Left Header"],
Cell[5108, 202, 100, 5, 46, "Input"],
Cell[5211, 209, 157, 4, 32, "Left Header"],
Cell[5371, 215, 77, 2, 29, "Input"],
Cell[5451, 219, 129, 3, 70, "Left Header"],
Cell[5583, 224, 303, 7, 104, "Left Header"],
Cell[5889, 233, 508, 22, 335, "Input"],
Cell[6400, 257, 302, 11, 54, "Left Header"],
Cell[6705, 270, 151, 6, 80, "Input"],
Cell[6859, 278, 104, 5, 46, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

