(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3983,        160]*)
(*NotebookOutlinePosition[      4839,        190]*)
(*  CellTagsIndexPosition[      4795,        186]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Naive Gaussian Elimination and Back
Substitution:\
\>", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->28],

Cell["\<\
Here is the naive Gaussian elimination (i.e., without 
pivoting)  :\
\>", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->22],

Cell["\<\
Off[General::spell1];
Clear[GaussBasic,a0,b0];
GaussBasic[a0_,b0_] :=
Module[{a,b,k,n,x}, 
  a = a0;
  b = b0;  
  n = Length[b];
Clear[i,k];
For[k=1,k<=n-1,k++,
   For[i=k+1,i<=n,i++,
       z = N[ a[[i,k]]/a[[k,k]], digit];
       a[[i,k]]=0;            
         For[j=k+1, j <=n, j++,
           a[[i,j]]=N[ a[[i,j]]-
             z a[[k,j]], digit]; ];
   b[[i]]= N[b[[i]]-z b[[k]],digit]; 
   ]; 
 Print[MatrixForm[a]];          
 ];
 x = Table[0,{i,n}];
    x[[n]] = N[b[[n]]/a[[n,n]], digit];
    Clear[i,j,k];
    For[i=n-1,1<=i,i--,
      sum = 0;
      For[j=i+1,j<=n,j++,
        sum  = N[sum + a[[i,j]]*
          x[[j]],digit] ]; 
      x[[i]] = N[(b[[i]] - sum)/
        a[[i,i]], digit]; ];         
 Return[x]; ];
 On[General::spell1];       \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[digit]; 
digit=7; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox["Examle 1",
    FontSize->20],
  StyleBox[": Here is a systems of 4 by 4,  ",
    FontSize->20,
    FontWeight->"Plain"]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18,
  FontWeight->"Bold"],

Cell["\<\
Clear[A,B]; 
A = {{2,4,-4,0},{1,5,-5,-3},{2,3,1,3},{1,4,-2,2}};
B = {12,18,8,8};
MatrixForm[A] \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["N[ GaussBasic[A,B], 7]", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox["Examle 2",
    FontSize->20],
  StyleBox[
  ": Here is a systems of 3 by 3, which can't be \nsolved by naive Gaussian,",
    
    FontSize->20,
    FontWeight->"Plain"]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18,
  FontWeight->"Bold"],

Cell["\<\
Clear[A,B]; 
A = {{1,2,-4},{2,4,-5},{2,3,1}};
B = {12,18,8 };
MatrixForm[A]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[" N[ GaussBasic[A,B], 7]", "Input",
  AspectRatioFixed->True,
  FontSize->18]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 600},
WindowMargins->{{Automatic, 146}, {Automatic, 15}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 144, 6, 70, "Left Header"],
Cell[1856, 57, 162, 6, 56, "Left Header"],
Cell[2021, 65, 826, 34, 573, "Input"],
Cell[2850, 101, 91, 5, 46, "Input"],
Cell[2944, 108, 252, 10, 31, "Left Header"],
Cell[3199, 120, 162, 7, 97, "Input"],
Cell[3364, 129, 81, 2, 29, "Input"],
Cell[3448, 133, 301, 12, 54, "Left Header"],
Cell[3752, 147, 142, 7, 80, "Input"],
Cell[3897, 156, 82, 2, 29, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

