(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7844,        286]*)
(*NotebookOutlinePosition[      8698,        316]*)
(*  CellTagsIndexPosition[      8654,        312]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["SOR Iteration", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->28],

Cell["We consider Gauss-Seidel iteration:", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->22],

Cell["\<\
Off[General::spell1];
Clear[SOR,a0,b0, r0, M0];
SOR[a0_,b0_, r0_, M0_] :=
Module[{a,b,k,n,x,u,r},
  a = a0; b = b0; M = M0; r = r0;
  n = Length[b];
  x = Table[0,{i, n}];
  u = Table[0, {i,n}];
  Clear[i,k];
  For[k=1,k<=M,k++,
    For[i=1, i<=n, i++,
       u[[i]] = (b[[i]] - Sum[a[[i,j]] x[[j]], {j,1,i-1}]
         - Sum[a[[i,j]] x[[j]], {j,i+1,n}])/a[[i,i]];
       x[[i]] = x[[i]] + r (u[[i]] - x[[i]]) ];
    Print[N[x,10]];  ]; 
  Return[x]; ]  
  On[General::spell1];    \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox["Examle 1",
    FontSize->22,
    FontWeight->"Bold"],
  StyleBox[":  Here is a 3 by 3 system,",
    FontSize->22]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[A,B];  
A = {{8,-1,1},{-1,8,1},{1,1,6}};
B = {8,8,8};  
StringForm[\"A= ``    B = ``\", MatrixForm[A], MatrixForm[B]] \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox[
"If we take omega =1, this is the same as Gauss-Seidel: ",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["N[SOR[A,B,1,10],10] ", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox[
"Let us find the optimal omega and use it in SOR method:",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[n,Q,rho]; 
n=Length[A]; 
Q =  DiagonalMatrix[Table[1/A[[i,i]], {i,1,n}]];
rho=Max[N[Abs[Eigenvalues[IdentityMatrix[3] - Q. A]],10]];
omega= 2/(1+ (1- rho^2)^(1/2) ) \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["SOR[A,B,omega,10]  ", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox["Examle 2",
    FontSize->22,
    FontWeight->"Bold"],
  StyleBox[
  ":  Here is a 4 by 4 system which is a typical \ncase when SOR method \
applies (the system arises \nfrom solving Laplacian equation on [0,1]^2 with \
16 \npoints). ",
    FontSize->22]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[A,B];  
A = {{1,0,-1/4,-1/4},{0,1,-1/4,-1/4},{-1/4,-1/4,1,0},
      {-1/4,-1/4,0,1}};
B = {1,1,1,1};   
StringForm[\"A= ``    B = ``\", MatrixForm[A], MatrixForm[B]] \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox[
"If we take omega =1, this is the same as\n Gauss-Seidel: ",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->23],

Cell["N[SOR[A,B,1,10],10]  ", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox[
"Let us find the optimal omega and use it in SOR method:",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[n,Q,rho]; 
n=Length[A];
Q =  DiagonalMatrix[Table[1/A[[i,i]], {i,1,n}]];
rho=Max[N[Abs[Eigenvalues[IdentityMatrix[n] - Q. A]],10]];
omega= 2/(1+ (1- rho^2)^(1/2) ) \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["N[SOR[A,B,omega,10],10]  ", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox["Let us compute the spectral radius of I-Q^{-1}A:",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[Q]; 
L=Table[If[i >j, -A [[i,j]], 0], {i,n},{j,n}];   
Q =(DiagonalMatrix[Table[A[[i,i]],{i,1,n}]]-omega L)/omega;
Max[N[Abs[Eigenvalues[IdentityMatrix[n]-Inverse[Q]. A]],10]]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox[
"Comparing to Jacobi method whose spectral radial \nis 0.5, and Gauss-Seidel \
method whose spectral \nradial is 0.25, we say that the SOR method works \n\
very nicely in this case. ",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox["Examle 3",
    FontSize->22,
    FontWeight->"Bold"],
  StyleBox[
  ":  Here is the  3 by 3 system, which  we \nconsidered before using Jacobi \
and Gauss-Seidel \nmethod.   The solution is given by (1/3,1/3,1/3). ",
    FontSize->22]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[A,B];
A={ {1,1/2,1/3}, {1/3,1,1/2},{1/2,1/3,1} };   
B={11/18,11/18,11/18};       \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["SOR[A,B,1,10]//N   ", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox[
"Let us find the optimal omega and use it in SOR \nmethod:",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[n,Q,rho]; 
n=Length[A];
Q =  DiagonalMatrix[Table[1/A[[i,i]], {i,1,n}]];
rho=Max[N[Abs[Eigenvalues[IdentityMatrix[3] - Q. A]],10]];
omega= 2/(1+ (1- rho^2)^(1/2) ) \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["N[SOR[A,B,omega,10],10]   ", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox["Let us comute the spectral radius of this method, ",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[Q]; 
L=Table[If[i >j, -A [[i,j]], 0], {i,n},{j,n}];   
Q =(DiagonalMatrix[Table[A[[i,i]],{i,1,n}]]-omega L)/omega;
Max[N[Abs[Eigenvalues[IdentityMatrix[n]-Inverse[Q]. A]],10]]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[StyleBox[
"Compare these results with Gauss-Seidel iteration, \nwhose spectral radius  \
is 0.35355339, we see that the \n\"optimal\" choice is actually worse. The \
reason is that \nthis matrix is not symmetric or positive definite, the \n\
theorem on optimal choice of parameter does not \napply.  This example shows \
that  one needs to check \nthe conditions carefully before using the SOR\n \
method. ",
  FontSize->22]], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 600},
WindowMargins->{{Automatic, 52}, {Automatic, 7}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 100, 3, 39, "Left Header"],
Cell[1812, 54, 122, 3, 32, "Left Header"],
Cell[1937, 59, 548, 20, 352, "Input"],
Cell[2488, 81, 224, 9, 32, "Left Header"],
Cell[2715, 92, 191, 7, 97, "Input"],
Cell[2909, 101, 179, 5, 56, "Left Header"],
Cell[3091, 108, 79, 2, 29, "Input"],
Cell[3173, 112, 179, 5, 56, "Left Header"],
Cell[3355, 119, 238, 8, 131, "Input"],
Cell[3596, 129, 78, 2, 29, "Input"],
Cell[3677, 133, 364, 12, 104, "Left Header"],
Cell[4044, 147, 239, 8, 131, "Input"],
Cell[4286, 157, 181, 5, 56, "Left Header"],
Cell[4470, 164, 80, 2, 29, "Input"],
Cell[4553, 168, 179, 5, 56, "Left Header"],
Cell[4735, 175, 237, 8, 131, "Input"],
Cell[4975, 185, 84, 2, 29, "Input"],
Cell[5062, 189, 171, 4, 32, "Left Header"],
Cell[5236, 195, 248, 7, 131, "Input"],
Cell[5487, 204, 305, 7, 104, "Left Header"],
Cell[5795, 213, 345, 11, 80, "Left Header"],
Cell[6143, 226, 155, 6, 80, "Input"],
Cell[6301, 234, 78, 2, 29, "Input"],
Cell[6382, 238, 181, 5, 56, "Left Header"],
Cell[6566, 245, 237, 8, 131, "Input"],
Cell[6806, 255, 85, 2, 29, "Input"],
Cell[6894, 259, 173, 4, 32, "Left Header"],
Cell[7070, 265, 248, 7, 131, "Input"],
Cell[7321, 274, 519, 10, 200, "Left Header"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

