(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6496,        265]*)
(*NotebookOutlinePosition[      7352,        295]*)
(*  CellTagsIndexPosition[      7308,        291]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Euler's Method:", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->29,
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[TextData[{
  StyleBox[" ",
    FontSize->16,
    FontSlant->"Plain"],
  "Here is the Euler's method of solving x' = f(t,x) with initial\n value \
x(a) = x0:   x_{k+1} = x_k + f(t_k, x_k).   "
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Off[General::spell1];
Clear[Euler,f0,a,b,x0,n];
Euler[f0_,a_,b_,x0_,n_] :=
Module[{f,h,k,T, X },
  Set@@{f[t_,x_],f0};
  h = (b - a)/ n //N ;
  T = Table[0,{n+1}];
  X = Table[0,{n+1}];
  T[[1]] =  a //N;
  X[[1]] = x0 //N;
  For[k=1, k<=n, k++,
    X[[k+1]] = X[[k]] +
        h f[T[[k]],X[[k]]] //N;
    T[[k+1]] = a + h k //N];
  Return[ Transpose[{T,X}] ] ];
On[General::spell1];  \
\>", "Input",
  AspectRatioFixed->False,
  FontSize->18],

Cell[TextData[{
  StyleBox["Examle 1:",
    FontWeight->"Bold"],
  "  Differential Eqn: x' = Cos[t] - Sin[x] + t^2 with\ninitial value x(-1) \
=3."
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[f,t,x];   
f[t_,x_] = Cos[t] - Sin[x] +t^2;\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["Euler[f[t,x],-1,1,3,10]  ", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[pts];
pts = Euler[f[t,x],-1,1,3,10];
dots= ListPlot[pts,PlotStyle->
{PointSize[0.015]}, DisplayFunction->  Identity];
lines= ListPlot[pts,PlotJoined->True, AspectRatio -> 0.5 , DisplayFunction->  \
Identity ]; 
Show[ lines, dots, DisplayFunction->
$DisplayFunction]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox[" ",
    FontWeight->"Bold"],
  "Here is the computation with 200 points: "
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[pts];
pts = Euler[f[t,x],-1,1,3,200];
ListPlot[pts,PlotJoined->True, AspectRatio -> 0.5]; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox[" ",
    FontWeight->"Bold"],
  "Compare with Mathematica solution:  "
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[ss];
ss=NDSolve[{x'[t]==f[t,x[t]],
      x[-1]==3},x[t],{t,-1,1}];
Plot[Evaluate[x[t]/.ss],
  {t,-1,1},AspectRatio -> 0.5];  \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
According to Mathematica description, this solution is good 
up to MachinePrecision -10 = 6 digits.  Let us look at the error
on the first 10 evaluation points, while  h = 2/200 = 0.01:\
\>", 
  "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[xx];
xx[t_]= x[t] /. First[ss];
Error = Table[pts[[i,2]]-
   xx[-1+ (i-1) /100], {i,1,10}]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Note: this solution is a very flat curve, we don't see much of 
the accumulation of errors. See the next example.  \
\>", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox["Examle 2:",
    FontWeight->"Bold"],
  "  Differential Eqn: x' = x[t] + Exp[t] + t x[t] with\ninitial value x( 1) \
=2."
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[f,t,x];
f[t_,x_] = (t *x - x^2) / t^2; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[pts];
pts = Euler[f[t,x],1,3,2,200 ];
ListPlot[pts,PlotJoined->True, AspectRatio -> 1]; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox[" ",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "Compare with the exact solution: "
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[ss,xx];
ss=DSolve[{x'[t]==f[t,x[t]],x[1]==2},
  x[t],t];
xx[t_]= x[t] /. First[ss] \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["Plot[xx[t],{t, 1,3},AspectRatio -> 1]  ", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Let us look at the error on the first 11 points being evaluated, 
where h = 2/100 = 0.05.\
\>", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Error1 = Table[pts[[i,2]]-
   xx[1+ (i-1) /100], {i,1,10}]//N \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
We know the local errors accumulating from step to step, so
that the error should get worse as k get large. Let us look at
the error on the last 11 points being evaluated.\
\>", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Error2=Table[pts[[i,2]]-
   xx[1+ (i-1) /100], {i,90,100}]//N \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 600},
WindowMargins->{{Automatic, 116}, {Automatic, 29}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 147, 5, 39, "Left Header"],
Cell[1859, 56, 279, 9, 47, "Left Header"],
Cell[2141, 67, 453, 19, 284, "Input"],
Cell[2597, 88, 230, 8, 46, "Left Header"],
Cell[2830, 98, 116, 5, 46, "Input"],
Cell[2949, 105, 84, 2, 29, "Input"],
Cell[3036, 109, 338, 11, 182, "Input"],
Cell[3377, 122, 185, 7, 27, "Left Header"],
Cell[3565, 131, 163, 6, 80, "Input"],
Cell[3731, 139, 180, 7, 27, "Left Header"],
Cell[3914, 148, 198, 8, 97, "Input"],
Cell[4115, 158, 283, 8, 65, "Left Header"],
Cell[4401, 168, 163, 7, 80, "Input"],
Cell[4567, 177, 210, 6, 46, "Left Header"],
Cell[4780, 185, 231, 8, 46, "Left Header"],
Cell[5014, 195, 112, 5, 46, "Input"],
Cell[5129, 202, 161, 6, 80, "Input"],
Cell[5293, 210, 219, 9, 28, "Left Header"],
Cell[5515, 221, 156, 7, 80, "Input"],
Cell[5674, 230, 98, 2, 29, "Input"],
Cell[5775, 234, 184, 6, 46, "Left Header"],
Cell[5962, 242, 129, 5, 46, "Input"],
Cell[6094, 249, 266, 7, 65, "Left Header"],
Cell[6363, 258, 129, 5, 46, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

