(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5716,        228]*)
(*NotebookOutlinePosition[      6572,        258]*)
(*  CellTagsIndexPosition[      6528,        254]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Taylor Series Method of Order 4:", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->29,
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell["\<\
 Here is the Taylor Series method of ordr 4 for solving
 x' = f(t,x) with  initial value x(a) = x0. \
\>", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Off[General::spell1];
Clear[TaylorM ,f0,a,b,x0,n];
TaylorM[f0_,a_,b_,x0_,n_] :=
Module[{d1,d2,d3,d4,f,h,j,T, X,X2,X3,X4},
  Set@@{f[t_,x_],f0};
  X'[t] = f[t,X[t]];
  X2=D[X[t],{t,2}]; 
  X3=D[X[t],{t,3}]; 
  X4=D[X[t],{t,4}]; 
  Set@@{d1[t_,x_],f[t,x]};
  Set@@{d2[t_,x_], X2/. X[t]->x };
  Set@@{d3[t_,x_], X3/. X[t]->x };
  Set@@{d4[t_,x_], X4/. X[t]->x };
  h = (b - a)/n //N;
  T = Table[0,{n+1}];
  X = Table[0,{n+1}];
  T[[1]] = a //N;
  X[[1]] = x0 //N;
  For[j=1, j<=n,j++,
    tj = T[[j]] //N;
    xj = X[[j]] //N;
    T[[j+1]] = a  + h j //N;
    X[[j+1]] = xj + h(d1[tj,xj] + 
     h(d2[tj,xj]/2 + h(d3[tj,xj]/6 +
     h d4[tj,xj]/24))); ];
  Return[Transpose[{T,X}]] ];
On[General::spell1];\
\>", "Input",
  AspectRatioFixed->False,
  FontSize->18],

Cell[TextData[{
  StyleBox["Examle 1:",
    FontWeight->"Bold"],
  "  Differential Eqn: x' = Cos[t] - Sin[x] + t^2 with\ninitial value x(-1) \
=3."
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[f,t,x];   
f[t_,x_] = Cos[t] - Sin[x] +t^2;\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["TaylorM[f[t,x],-1,1,3,10]  ", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[pts];
pts = TaylorM[f[t,x],-1,1,3,100];
ListPlot[pts,PlotJoined->True, AspectRatio -> 0.5]; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox[" ",
    FontWeight->"Bold"],
  "Compare with Mathematica solution:  "
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[ss];
ss=NDSolve[{x'[t]==f[t,x[t]],x[-1]==3},x[t],{t,-1,1}];
Plot[Evaluate[x[t]/.ss],{t,-1,1},AspectRatio -> 0.5];  \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
According to Mathematica description, this solution is good up
to MachinePrecision -10 = 6 digits.  Let us look at the error on
the first 10 evaluation points, while  h = 2/100 = 0.05:\
\>", "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[xx];
xx[t_]= x[t] /. First[ss];
Error = Table[pts[[i,2]]-xx[-1+ (i-1) /50], {i,1,10}]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox["Examle 2:",
    FontWeight->"Bold"],
  "  Differential Eqn: x' = x[t] + Exp[t] + t x[t] with\ninitial value x( 1) \
=2."
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[f,t,x];
f[t_,x_] = (t *x - x^2) / t^2; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[pts];
pts = TaylorM[f[t,x],1,3,2,100 ];
ListPlot[pts,PlotJoined->True, AspectRatio -> 1]; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox[" ",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "Compare with the exact solution: "
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[ss,xx];
ss=DSolve[{x'[t]==f[t,x[t]],x[1]==2},
   x[t],t];
xx[t_]= x[t] /. First[ss] \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell["Plot[xx[t], {t, 1,3},AspectRatio -> 1]  ", "Input",
  AspectRatioFixed->True,
  FontSize->18],

Cell[TextData[{
  StyleBox[" ",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "Let us look at the error on the first 11 evaluation points, \n while  h = \
2/100 = 0.05."
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontSize->18],

Cell["\<\
Clear[xx];
xx[t_]= x[t] /. First[ss];
Error = Table[pts[[i,2]]-xx[1+ (i-1) /50], {i,1,10}]//N \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->18]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 600},
WindowMargins->{{Automatic, 117}, {70, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 164, 5, 39, "Left Header"],
Cell[1876, 56, 195, 6, 46, "Left Header"],
Cell[2074, 64, 771, 30, 488, "Input"],
Cell[2848, 96, 230, 8, 46, "Left Header"],
Cell[3081, 106, 116, 5, 46, "Input"],
Cell[3200, 113, 86, 2, 29, "Input"],
Cell[3289, 117, 165, 6, 80, "Input"],
Cell[3457, 125, 180, 7, 27, "Left Header"],
Cell[3640, 134, 188, 6, 97, "Input"],
Cell[3831, 142, 279, 7, 65, "Left Header"],
Cell[4113, 151, 158, 6, 80, "Input"],
Cell[4274, 159, 231, 8, 46, "Left Header"],
Cell[4508, 169, 112, 5, 46, "Input"],
Cell[4623, 176, 163, 6, 80, "Input"],
Cell[4789, 184, 219, 9, 28, "Left Header"],
Cell[5011, 195, 157, 7, 80, "Input"],
Cell[5171, 204, 99, 2, 29, "Input"],
Cell[5273, 208, 275, 10, 47, "Left Header"],
Cell[5551, 220, 161, 6, 80, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

