(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8001,        276]*)
(*NotebookOutlinePosition[      8856,        308]*)
(*  CellTagsIndexPosition[      8812,        304]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[TextData["Finite Difference Method for Heat Eqn:"], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times",
  FontSize->23,
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}],

Cell[TextData[{
  StyleBox[
  "We use the explicit algorithm of finite difference method to solve \nthe \
heat equation  \n\t\t u",
    FontSize->16,
    FontSlant->"Plain"],
  StyleBox["t",
    FontSize->16,
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->"Subscript"}],
  StyleBox["(x,t) =  u",
    FontSize->16,
    FontSlant->"Plain"],
  StyleBox["xx",
    FontSize->16,
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->"Subscript"}],
  StyleBox[
  "(x,t)  , \n   \t\t u(x,0) = f(x),  for 0 <= x <= a ,   \n      \t\t u(0,t) \
 = a(t),  u(1,t)  = b(t),   for  t =>0 , \n over  R = {(x,t): 0 <= x <= 1 , \
t=>0}.  The algorithm looks for the\n solution at  mesh points (x_i,t_j) with \
x_i = i*h and t_j = j *k.",
    FontSize->16,
    FontSlant->"Plain"]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Off[General::spell1];\nClear[ForwardHeat,a,b,g, n, k, M,u]; \n\
ForwardHeat[a0_,b0_,g0_,n_,k_,M_] :=\nModule[{a,b,g,h,s,i,j},  \n  \
Set@@{a[t_],a0};\n  Set@@{b[t_],b0};\n  Set@@{g[x_],g0};\n  h = (1 / n)//N;\n \
 s = (k / h^2) //N;\nu = Table[1,{n+1},{M}];\n  For[i=1,i<=n+1 ,i++,\n      \
u[[i,1]] = g[(i-1)*h] //N ];\n  For[j=1,j<=M,j++,\n      u[[1,j]] = a[j*k] \
//N ;\n      u[[n+1,j]] = b[j*k] //N ];\n  For[j=2,j<=M,j++,\n    \
For[i=2,i<=n,i++,\n      u[[i,j]]=  s*u[[i-1,j-1]]+\n            \
(1-2s)*u[[i,j-1]] + s*u[[i+1,j-1]]  ];]; ]; \nOn[General::spell1] "], "Input",\

  AspectRatioFixed->False],

Cell[TextData[{
  StyleBox["Examle 1:",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[
  "   Boundary values: u(x,0) = 4x(1-x),  for 0 <= x <= 1, and \n u(0,t)  = \
0,  u(1,t)  = 0.   ",
    FontSize->16,
    FontSlant->"Plain"]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Clear[g,t,x];\ng[x_]:= 4*x -4*x^2; \na[t_]:=0;\nb[t_]:=0;"], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[" ",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[
  "First we solve it with h = 1/5 =0.2, and k =0.02, we solve it up to \n \
M=20, that is, for t up to b=k*M=0.4. (here s=0.5)",
    FontSize->16,
    FontSlant->"Plain"]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["ForwardHeat[a[t],b[t],g[x], 5, 0.02, 20] "], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"ListPlot3D[u,  AxesLabel->{\"t\",\"x\",\"u\"},  \nViewPoint->{4,2,3}]"], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData["TableForm[Chop[Transpose[u]]];"], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[" ",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[
  "Not all pair of (h,k) will lead to solution.  Here we solve the system\n \
with h = 1/5 =0.2, and k =0.06 up to M=15. (here s =1.5)",
    FontSize->16,
    FontSlant->"Plain"]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["ForwardHeat[a[t],b[t],g[x], 5, 0.06, 15] "], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"ListPlot3D[u,  AxesLabel->{\"t\",\"x\",\"u\"},  \nViewPoint->{4,2,3}]"], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData["TableForm[Chop[Transpose[u]]]; "], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Examle 2:",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[
  "   Boundary values: u(x,0) = sin Pi x,  for 0 <= x <= 1, and \n u(0,t)  = \
0,  u(1,t)  = 0.   ",
    FontSize->16,
    FontSlant->"Plain"]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Clear[g,t,x];\ng[x_]:= Sin[Pi*x];\na[t_]:=0;\nb[t_]:=0; "], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[" ",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[
  "First we solve it with h = 1/10 =0.1, and k =0.005125, we solve it up\n to \
M=200, that is, for t up to b=k*M= 1.025.",
    FontSize->16,
    FontSlant->"Plain"]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["ForwardHeat[a[t],b[t],g[x], 10, 0.005125, 200]"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"ListPlot3D[u,  AxesLabel->{\"t\",\"x\",\"u\"},  \nViewPoint->{1,2,1}]"], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[" ",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox["The exact solution is this case is known to be",
    FontSize->16,
    FontSlant->"Plain"]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["uu[x_,t_]:=Exp[- Pi^2 t] * Sin[Pi *x]; "], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Error = Max[Abs[ Table[u[[i,j]]-\n    uu[0.1*(i-1),0.005125*(j-1)] //N,  \n\
{i,1,11},{j,1,200}]]]"], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[" ",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox["In this case, we have that s = k / h^2 = 0.5125. ",
    FontSize->16,
    FontSlant->"Plain"]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[" ",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[
  "Not all pair of (h,k) will lead to solution.  We solve the system again\n \
with h = 0.1, and k =0.006 up to M=171; here b=k*M=1.026.",
    FontSize->16,
    FontSlant->"Plain"]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["ForwardHeat[a[t],b[t],g[x], 10, 0.006, 171]  "], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Error = Max[Abs[ Table[u[[i,j]]-\n    uu[0.1*(i-1),0.005125*(j-1)] //N,  \n\
{i,1,11},{j,1,171}]]]"], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[" ",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox["In this case, we have that s = k / h^2 = 0.6 > 1/2.",
    FontSize->16,
    FontSlant->"Plain"]
}], "Left Header",
  Evaluatable->False,
  AspectRatioFixed->True]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1152}, {0, 864}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 600},
WindowMargins->{{304, Automatic}, {37, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1711, 51, 307, 10, 70, "Left Header"],
Cell[2021, 63, 860, 26, 70, "Left Header"],
Cell[2884, 91, 626, 10, 70, "Input"],
Cell[3513, 103, 327, 12, 70, "Left Header"],
Cell[3843, 117, 111, 2, 70, "Input"],
Cell[3957, 121, 348, 12, 70, "Left Header"],
Cell[4308, 135, 94, 1, 70, "Input"],
Cell[4405, 138, 126, 3, 70, "Input"],
Cell[4534, 143, 83, 1, 70, "Input"],
Cell[4620, 146, 356, 12, 70, "Left Header"],
Cell[4979, 160, 94, 1, 70, "Input"],
Cell[5076, 163, 126, 3, 70, "Input"],
Cell[5205, 168, 84, 1, 70, "Input"],
Cell[5292, 171, 328, 12, 70, "Left Header"],
Cell[5623, 185, 110, 2, 70, "Input"],
Cell[5736, 189, 343, 12, 70, "Left Header"],
Cell[6082, 203, 99, 1, 70, "Input"],
Cell[6184, 206, 126, 3, 70, "Input"],
Cell[6313, 211, 268, 10, 70, "Left Header"],
Cell[6584, 223, 92, 1, 70, "Input"],
Cell[6679, 226, 152, 3, 70, "Input"],
Cell[6834, 231, 271, 10, 70, "Left Header"],
Cell[7108, 243, 358, 12, 70, "Left Header"],
Cell[7469, 257, 98, 1, 70, "Input"],
Cell[7570, 260, 152, 3, 70, "Input"],
Cell[7725, 265, 273, 10, 70, "Left Header"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
