/* No jet */
/************************************************************************
 *
 *  A sample taylor.h
 *     Here is a list of macros/functions needed to compile the auto
 *     generated taylor polynomial procedure.  
 *
 */


#ifdef __cplusplus
extern "C"
{
#endif
/***********************************************************************
 *
 * Code generated by the TAYLOR translator.
 */

#ifndef _NUMBER_OF_JET_VARS_
#define _NUMBER_OF_STATE_VARS_         2
#define _NUMBER_OF_JET_VARS_           0
#define _NUMBER_OF_SYMBOLS_            0
#define _DEGREE_OF_JET_VARS_           0
#define _JET_COEFFICIENTS_COUNT_TOTAL_ 1
static int _number_of_jet_vars_ =      0;
static int _number_of_symbols_  =      0;
static int _degree_of_jet_vars_ =      0;
static int _monomial_counts_[]  =      {1};
static int _monomial_offsets_[] =      {0,1};
static int _size_of_jet_variable_ =    1;
#define _SIZE_OF_JET_VAR_              1
#endif

#ifndef _TAYLOR_H_
#define _TAYLOR_H_
typedef double MY_FLOAT;

#include<math.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<ctype.h>
/*
 *  MY_FLOAT is the data type to be used in computing derivatives. 
 *  It may be 'float', 'double' or user defined private data types
 *  like 'long double', 'complex' etc. 
 */

/* for double or long double, don't need to initialize */
#define   InitMyFloat(r)            
#define   ClearMyFloat(r)           
 
/* assign b to a */
#define   AssignMyFloat(a, b)       {(a)=(b);}

/* create a MY_FLOAT from a, assigne to r. a is an integer or a float */
#define   MakeMyFloatA(r,a)         (r=(double)(a))

/* create a MY_FLOAT from string, a is an integer or a float, s is its string representation */
#define   MakeMyFloatC(r,s,a)       (r=(double)(a))

/* create a MY_FLOAT from a, assign to r and return r */
#define   MakeMyFloatB(r,a)         (r=(double)(a),r)

/* addition r=a+b   */
#define   AddMyFloatA(r,a,b)        (r=(a)+(b))
#define   AddMyFloatD               AddMyFloatA
#define   AddMyFloatSI              AddMyFloatA

/* substraction r=a-b */
#define   SubtractMyFloatA(r,a,b)   (r=(a)-(b))
#define   SubtractMyFloatD          SubtractMyFloatA
#define   SubtractMyFloatSI         SubtractMyFloatA
#define   SubtractSIMyFloat         SubtractMyFloatA

/* multiplication r=a*b */
#define   MultiplyMyFloatA(r,a,b)   (r=(a)*(b))
#define   MultiplyMyFloatD          MultiplyMyFloatA
#define   MultiplyMyFloatSI         MultiplyMyFloatA

/* division r=a/b */
#define   DivideMyFloatA(r,a,b)     (r=(a)/(b))
#define   DivideMyFloatD(r,a,b)     (r=(a)/(double)(b))
#define   DivideMyFloatSI           DivideMyFloatD

/* division by an integer r=a/i */
#define   DivideMyFloatByInt(r,a,i)    (r=(a)/(double)(i))
/* negation r=-a*/
#define   NegateMyFloatA(r,a)          (r= -(a))

/* square root r=sqrt(a) */
#define   sqrtMyFloatA(r,a)            (r=sqrt(a))
/* exponentiation r=a^b */
#define   ExponentiateMyFloatA(r,a,b)  (r=pow((a),(b)))
/* exponentiation r=a^b, b is an integer */
#define   ExponentiateMyFloatIA(r,a,b) (r=pow((a),(double)(b)))
/* sin(a)  r=sin(a) */
#define   sinMyFloatA(r,a)             (r=sin((a)))
/* cos(a)  r=cos(a) */
#define   cosMyFloatA(r,a)             (r=cos((a)))
/* tan(a)  r=tan(a) */
#define   tanMyFloatA(r,a)             (r=tan((a)))
/* atan(a) r=atan(a) */
#define   atanMyFloatA(r,a)            (r=atan((a)))
/* exp(a)  r=exp(a) */
#define   expMyFloatA(r,a)             (r=exp((a)))
/* log(a)  r=log(a) */
#define   logMyFloatA(r,a)             (r=log((a)))
/* sinh(a) r=sinh(a) */
#define   sinhMyFloatA(r,a)            (r=sinh(a))
/* cosh(a) r=cosh(a) */
#define   coshMyFloatA(r,a)            (r=cosh(a))
/* tanh(a) r=tanh(a) */
#define   tanhMyFloatA(r,a)            (r=tanh(a))


/* log10(a)  r=log10(a) */
#define   log10MyFloatA(r,a)           (r=log10((a)))
/* fabs(a) r=fabs(a) */
#define   fabsMyFloatA(r,a)            (r=fabs(a))

/* convert to int */
#define   MyFloatToInt(ir,fa)          (ir=(int)(fa))
/* convert to double */
#define   MyFloatToDouble(ir,fa)       (ir=(double)(fa))


/* boolean operation  */
#define   MyFloatA_GE_B(a,b)        ((a)>=(b))
#define   MyFloatA_GT_B(a,b)        ((a)> (b))
#define   MyFloatA_LE_B(a,b)        ((a)<=(b))
#define   MyFloatA_LT_B(a,b)        ((a)< (b))
#define   MyFloatA_EQ_B(a,b)        ((a)==(b))
#define   MyFloatA_NEQ_B(a,b)       ((a)!=(b))


#define   OutputMyFloat(a)          fprintf(stdout,"%g ",(double)a)
#define   OutputMyFloat3(file,format,a)     fprintf(file,format,(double)a)

/************************************************************************/

#endif

/*** MY_JET ***/
#ifndef _MY_JET_H_
#define _MY_JET_H_
#define MY_JET_DATA(x,i) (x[i])
typedef void* MY_JET;

typedef void* MY_JET;


#endif /*_MY_JET_H_ */ 

MY_FLOAT **taylor_coefficients_perturbation(MY_FLOAT t, MY_FLOAT *x, int order);

MY_FLOAT **taylor_coefficients_perturbationA(MY_FLOAT t, MY_FLOAT *x, int order, int reuse_last_computation);

MY_FLOAT **taylor_coefficients_perturbation_A(MY_FLOAT t, MY_FLOAT *x, int order, int reuse_last_computation, MY_JET *jetIn, MY_JET ***jetOut);
int       taylor_step_perturbation(MY_FLOAT *ti, MY_FLOAT *x, int dir, int step_ctl,
                          double log10abserr, double log10relerr, 
                          MY_FLOAT *endtime, MY_FLOAT *ht, int *order, MY_JET *jetInOut);

/************************************************************************/

#ifdef __cplusplus
}
#endif
